package ru.yandex.search.salo;

import java.math.BigDecimal;

import ru.yandex.util.string.PrettyPrint;

public class PingEnvelope extends Envelope {
    private static final byte[] EMPTY_BUF = new byte[0];

    private final int shard;

    public PingEnvelope(
        final long operationId,
        final EnvelopesContext context,
        final int shard)
    {
        this(operationId, null, context, shard);
    }

    public PingEnvelope(
        final long operationId,
        final String additionalUriParams,
        final EnvelopesContext context,
        final int shard)
    {
        super(EMPTY_BUF, new BigDecimal(operationId), context);
        this.shard = shard;
        uri.append("/ping?");
        uri.append(context.dbId());
        uri.append("&operation-id=");
        uri.append(operationId);
        uri.append("&operation-date=");
        PrettyPrint.millisToSeconds(uri, System.currentTimeMillis());
        uri.append("&shard=");
        uri.append(shard);
        if (additionalUriParams != null) {
            uri.append(additionalUriParams);
        }
    }

    @Override
    public int shard() {
        return shard;
    }

    @Override
    public boolean optional() {
        return true;
    }

    @Override
    public double operationDate() {
        return 0d;
    }

    @Override
    public int midsCount() {
        return 0;
    }

    @Override
    protected void writeAdditionalInfo(final StringBuilder sb) {
        sb.append("ping");
    }
}

