package ru.yandex.search.salo;

import java.io.IOException;

import org.apache.http.impl.client.CloseableHttpClient;

import ru.yandex.http.server.sync.BaseHttpServer;
import ru.yandex.http.util.client.ClientBuilder;
import ru.yandex.search.salo.config.ImmutableSaloConfig;

public class Salo extends BaseHttpServer<ImmutableSaloConfig> {
    private final CloseableHttpClient msalClient;
    private final CloseableHttpClient zoolooserClient;

    public Salo(final ImmutableSaloConfig config)
        throws IOException
    {
        super(config);

        msalClient = ClientBuilder.createClient(
            config.msalConfig(),
            config.dnsConfig());
        zoolooserClient = ClientBuilder.createClient(
            config.zoolooserConfig(),
            config.dnsConfig());
    }

    public CloseableHttpClient msalClient() {
        return msalClient;
    }

    public CloseableHttpClient zoolooserClient() {
        return zoolooserClient;
    }
}
