package ru.yandex.search.salo;

import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;

public class TransferStater implements Stater {
    private final Iterable<TransferStats> data;
    private final String transfersCountSignalName;
    private final String envelopesCountSignalName;
    private final String midsCountSignalName;
    private final String sizeSignalName;

    public TransferStater(
        final Iterable<TransferStats> data,
        final String statsPrefix)
    {
        this.data = data;
        transfersCountSignalName = statsPrefix + "-transfers_ammm";
        envelopesCountSignalName = statsPrefix + "-transferred-count_ammm";
        midsCountSignalName = statsPrefix + "-transferred-mids_ammm";
        sizeSignalName = statsPrefix + "-transferred-size_ammm";
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        int transfers = 0;
        int envelopesCount = 0;
        int midsCount = 0;
        int size = 0;
        for (TransferStats stat: data) {
            ++transfers;
            envelopesCount += stat.envelopesCount();
            midsCount += stat.midsCount();
            size += stat.size();
        }
        statsConsumer.stat(transfersCountSignalName, transfers);
        statsConsumer.stat(envelopesCountSignalName, envelopesCount);
        statsConsumer.stat(midsCountSignalName, midsCount);
        statsConsumer.stat(sizeSignalName, size);
    }
}

