package ru.yandex.search.salo.config;

import java.io.File;
import java.util.regex.Pattern;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractMailSaloConfigBuilder
    <T extends AbstractMailSaloConfigBuilder<T>>
     extends AbstractSaloConfigBuilder<T>
     implements MailSaloConfig
{
    private String zoolooserService;
    private String pgZoolooserService;
    private File mdblist;
    private File pgshards;
    private Pattern ssdMdbs;

    protected AbstractMailSaloConfigBuilder(final MailSaloConfig config) {
        super(config);
        zoolooserService(config.zoolooserService());
        pgZoolooserService(config.pgZoolooserService());
        mdblist(config.mdblist());
        pgshards(config.pgshards());
        ssdMdbs(config.ssdMdbs());
    }

    protected AbstractMailSaloConfigBuilder(
        final IniConfig config,
        final MailSaloConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig zoolooserSection = config.section("zoolooser");

        zoolooserService =
            zoolooserSection.getString("service", defaults.zoolooserService());
        pgZoolooserService = zoolooserSection.getString(
            "pg-service",
            defaults.pgZoolooserService());
        IniConfig salo = config.section("salo");
        mdblist = salo.getInputFile("mdblist", defaults.mdblist());
        pgshards = salo.getInputFile("pgshards", defaults.pgshards());

        ssdMdbs = salo.get(
            "ssd-mdbs",
            defaults.ssdMdbs(),
            Pattern::compile);
    }

    @Override
    public String zoolooserService() {
        return zoolooserService;
    }

    public T zoolooserService(final String zoolooserService) {
        this.zoolooserService = zoolooserService;
        return self();
    }

    @Override
    public String pgZoolooserService() {
        return pgZoolooserService;
    }

    public T pgZoolooserService(final String pgZoolooserService) {
        this.pgZoolooserService = pgZoolooserService;
        return self();
    }

    @Override
    public File mdblist() {
        return mdblist;
    }

    public T mdblist(final File mdblist) {
        this.mdblist = mdblist;
        return self();
    }

    @Override
    public File pgshards() {
        return pgshards;
    }

    public T pgshards(final File pgshards) {
        this.pgshards = pgshards;
        return self();
    }

    @Override
    public Pattern ssdMdbs() {
        return ssdMdbs;
    }

    public T ssdMdbs(final Pattern ssdMdbs) {
        this.ssdMdbs = ssdMdbs;
        return self();
    }
}
