package ru.yandex.search.salo.config;

import java.io.File;
import java.util.regex.Pattern;

import ru.yandex.parser.config.ConfigException;

public class ImmutableMailSaloConfig
     extends ImmutableSaloConfig
     implements MailSaloConfig
{
    private final String zoolooserService;
    private final String pgZoolooserService;
    private final File mdblist;
    private final File pgshards;
    private final Pattern ssdMdbs;

    public ImmutableMailSaloConfig(
        final MailSaloConfig config)
        throws ConfigException
    {
        super(config);
        this.zoolooserService = config.zoolooserService();
        this.pgZoolooserService = config.pgZoolooserService();
        this.mdblist = config.mdblist();
        this.pgshards = config.pgshards();
        this.ssdMdbs = config.ssdMdbs();

        if (zoolooserService == null) {
            throw new ConfigException("zoolooser.service is not set");
        }
        if (pgZoolooserService == null) {
            throw new ConfigException("zoolooser.pg-service is not set");
        }
        if (mdblist == null && pgshards == null) {
            throw new ConfigException(
                "Neither salo.mdblist nor salo.pgshards is set");
        }
    }

    @Override
    public String zoolooserService() {
        return zoolooserService;
    }

    @Override
    public String pgZoolooserService() {
        return pgZoolooserService;
    }

    @Override
    public File mdblist() {
        return mdblist;
    }

    @Override
    public File pgshards() {
        return pgshards;
    }

    @Override
    public Pattern ssdMdbs() {
        return ssdMdbs;
    }
}
