package ru.yandex.search.salo.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.stater.ImmutableStaterConfig;

public class ImmutableSaloConfig
    extends ImmutableHttpProxyConfig
    implements SaloConfig
{
    private final ImmutableHttpHostConfig msalConfig;
    private final ImmutableHttpHostConfig zoolooserConfig;
    private final int selectLength;
    private final int workerQueueLength;
    private final int workersPerMdb;
    private final int workersLookahead;
    private final int requestsBatchSize;
    private final int midsLimit;
    private final long envelopesCheckInterval;
    private final long lockCheckInterval;
    private final long sessionTimeout;
    private final ImmutableStaterConfig msalResponsesStaterConfig;
    private final ImmutableStaterConfig minTransactionStaterConfig;
    private final ImmutableStaterConfig transferLagStaterConfig;
    private final long activeShardsTimeFrame;

    public ImmutableSaloConfig(final SaloConfig config)
        throws ConfigException
    {
        super(config);
        msalConfig = new ImmutableHttpHostConfig(config.msalConfig());
        zoolooserConfig =
            new ImmutableHttpHostConfig(config.zoolooserConfig());

        selectLength = config.selectLength();
        workerQueueLength = config.workerQueueLength();
        workersPerMdb = config.workersPerMdb();
        workersLookahead = config.workersLookahead();
        requestsBatchSize = config.requestsBatchSize();
        midsLimit = config.midsLimit();
        envelopesCheckInterval = config.envelopesCheckInterval();
        lockCheckInterval = config.lockCheckInterval();
        sessionTimeout = config.sessionTimeout();
        msalResponsesStaterConfig =
            new ImmutableStaterConfig(config.msalResponsesStaterConfig());
        minTransactionStaterConfig =
            new ImmutableStaterConfig(config.minTransactionStaterConfig());
        transferLagStaterConfig =
            new ImmutableStaterConfig(config.transferLagStaterConfig());
        activeShardsTimeFrame = config.activeShardsTimeFrame();

        if (selectLength <= 0) {
            throw new ConfigException(
                "salo.select-length must be a positive value");
        }
        if (workerQueueLength <= 0) {
            throw new ConfigException(
                "salo.worker-queue-length must be a positive value");
        }
        if (workersPerMdb <= 0) {
            throw new ConfigException(
                "salo.workers-per-mdb must be a positive value");
        }
        if (workersLookahead < 0) {
            throw new ConfigException(
                "salo.workers-lookahead must be a non-negative value");
        }
        if (requestsBatchSize <= 0) {
            throw new ConfigException(
                "salo.requests-batch-size must be a positive value");
        }
        if (midsLimit <= 0) {
            throw new ConfigException(
                "salo.mids-limit must be a positive value");
        }
        if (envelopesCheckInterval < 0L) {
            throw new ConfigException(
                "salo.envelopes-check-interval must be a non-negative value");
        }
        if (lockCheckInterval < 0L) {
            throw new ConfigException(
                "salo.lock-check-interval must be a non-negative value");
        }
        if (sessionTimeout <= 0L) {
            throw new ConfigException(
                "salo.session-timeout must be a positive value");
        }
        if (activeShardsTimeFrame <= 0L) {
            throw new ConfigException(
                "salo.active-shards-time-frame frame must be "
                + "a positive value");
        }
    }

    @Override
    public ImmutableHttpHostConfig msalConfig() {
        return msalConfig;
    }

    @Override
    public ImmutableHttpHostConfig zoolooserConfig() {
        return zoolooserConfig;
    }

    @Override
    public int selectLength() {
        return selectLength;
    }

    @Override
    public int workerQueueLength() {
        return workerQueueLength;
    }

    @Override
    public int workersPerMdb() {
        return workersPerMdb;
    }

    @Override
    public int workersLookahead() {
        return workersLookahead;
    }

    @Override
    public int requestsBatchSize() {
        return requestsBatchSize;
    }

    @Override
    public int midsLimit() {
        return midsLimit;
    }

    @Override
    public long envelopesCheckInterval() {
        return envelopesCheckInterval;
    }

    @Override
    public long lockCheckInterval() {
        return lockCheckInterval;
    }

    @Override
    public long sessionTimeout() {
        return sessionTimeout;
    }

    @Override
    public ImmutableStaterConfig msalResponsesStaterConfig() {
        return msalResponsesStaterConfig;
    }

    @Override
    public ImmutableStaterConfig minTransactionStaterConfig() {
        return minTransactionStaterConfig;
    }

    @Override
    public ImmutableStaterConfig transferLagStaterConfig() {
        return transferLagStaterConfig;
    }

    @Override
    public long activeShardsTimeFrame() {
        return activeShardsTimeFrame;
    }
}

