package ru.yandex.search.salo.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class MailSaloConfigBuilder
     extends AbstractMailSaloConfigBuilder<MailSaloConfigBuilder>
{
    public MailSaloConfigBuilder() {
        this(MailSaloConfigDefaults.INSTANCE);
    }

    public MailSaloConfigBuilder(final MailSaloConfig config) {
        super(config);
    }

    public MailSaloConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, MailSaloConfigDefaults.INSTANCE);
    }

    public MailSaloConfigBuilder(
        final IniConfig config,
        final MailSaloConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableMailSaloConfig build() throws ConfigException {
        return new ImmutableMailSaloConfig(
            this);
    }

    @Override
    public MailSaloConfigBuilder self() {
        return this;
    }
}
