package ru.yandex.search.salo.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class SaloConfigBuilder
    extends AbstractSaloConfigBuilder<SaloConfigBuilder>
{
    public SaloConfigBuilder() {
        super(SaloConfigDefaults.INSTANCE);
    }

    public SaloConfigBuilder(final SaloConfig config) {
        super(config);
    }

    public SaloConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, SaloConfigDefaults.INSTANCE);
    }

    public SaloConfigBuilder(final IniConfig config, final SaloConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public SaloConfigBuilder self() {
        return this;
    }

    public ImmutableSaloConfig build() throws ConfigException {
        return new ImmutableSaloConfig(this);
    }
}

