package ru.yandex.search.salo.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.stater.StaterConfig;
import ru.yandex.stater.StaterConfigDefaults;

public class SaloConfigDefaults
    extends HttpProxyConfigDefaults
    implements SaloConfig
{
    public static final SaloConfigDefaults INSTANCE =
        new SaloConfigDefaults();

    private static final int DEFAULT_WORKERS_LOOKAHEAD = 8;
    private static final long DEFAULT_ENVELOPES_CHECK_INTERVAL = 1000L;
    private static final long DEFAULT_LOCK_CHECK_INTERVAL = 1000L;
    private static final long DEFAULT_SESSION_TIMEOUT = 10000L;
    private static final long DEFAULT_ACTIVE_SHARDS_TIME_FRAME = 600000L;

    protected SaloConfigDefaults() {
    }

    @Override
    public String name() {
        return "SALO";
    }

    @Override
    public HttpHostConfig msalConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig zoolooserConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public int selectLength() {
        return -1;
    }

    @Override
    public int workerQueueLength() {
        return -1;
    }

    @Override
    public int workersPerMdb() {
        return -1;
    }

    @Override
    public int workersLookahead() {
        return DEFAULT_WORKERS_LOOKAHEAD;
    }

    @Override
    public int requestsBatchSize() {
        return 1;
    }

    @Override
    public int midsLimit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long envelopesCheckInterval() {
        return DEFAULT_ENVELOPES_CHECK_INTERVAL;
    }

    @Override
    public long lockCheckInterval() {
        return DEFAULT_LOCK_CHECK_INTERVAL;
    }

    @Override
    public long sessionTimeout() {
        return DEFAULT_SESSION_TIMEOUT;
    }

    @Override
    public StaterConfig msalResponsesStaterConfig() {
        return StaterConfigDefaults.INSTANCE;
    }

    @Override
    public StaterConfig minTransactionStaterConfig() {
        return StaterConfigDefaults.INSTANCE;
    }

    @Override
    public StaterConfig transferLagStaterConfig() {
        return StaterConfigDefaults.INSTANCE;
    }

    @Override
    public long activeShardsTimeFrame() {
        return DEFAULT_ACTIVE_SHARDS_TIME_FRAME;
    }
}

