#!/bin/bash

SEARCHMAP=$1
TAG=$2
MD5_SUM=$(md5sum $SEARCHMAP | cut -d ' ' -f 1)
CACHE_FILE=copy-jobs_${MD5_SUM}.txt

if [ -s $CACHE_FILE ]; then
    cat $CACHE_FILE
else
    cat $SEARCHMAP | nice -n 20 gawk -f generate-copy-jobs.awk -v tag=$TAG > $CACHE_FILE".tmp"
    if [ $? -eq 0 ]; then
        mv $CACHE_FILE".tmp" $CACHE_FILE
        cat $CACHE_FILE
    else
	exit 1
    fi
fi
exit 0
