#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Script exiting with "1" error code if cannot get searchmap from cluster management system

import os
import urllib2
import time
import sys

CLUSTER_URL = "http://mage.n.yandex-team.ru{MAGE_URI}?revision={REVISION}&full=true{MAGE_PARAMS}"

TRIES = 2
SLEEP = 5


def make_auth_req_post(url, token=None, timeout=20):
    request = urllib2.Request(url)
    request.add_header('Content-Type', 'application/json')
    if token:
        request.add_header("Authorization", "OAuth {0}".format(token))
    attempts = 0
    while attempts < TRIES:
        try:
            result = urllib2.urlopen(request, timeout=timeout)
            break
        except Exception as e:
            attempts += 1
            print("Error reached {0} Url: {2} Retry count:{1}".format(e, attempts, url))
            time.sleep(SLEEP)
            if attempts == TRIES:
                print("Timeout!")
                raise Exception("Timeout exception!")
    return result.read()


if __name__ == "__main__":
    try:
        with open(os.environ["REVISION_FILE_PATH"], 'r') as f:
            revision = f.readlines()[0].strip()

        print("Revision change reached through notify hook: {0}".format(revision))

        mage_url = CLUSTER_URL.format(MAGE_URI=os.environ["MAGE_URI"], REVISION=revision, MAGE_PARAMS=os.environ["MAGE_PARAMS"])

        print("Getting map through url: {0}".format(mage_url))

        # Getting map
        answer_map = make_auth_req_post(mage_url)
        with open(os.environ["SEARCHMAP_PATH"], 'w+') as f:
            f.write(answer_map)

    except Exception as e:
        print("Cannot get latest searchmap version. Executing exception reached: {0}, exit with error".format(e))
        sys.exit(1)
