package ru.yandex.search.sharpei;

import java.util.Map;

import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class ConnInfo {
    private final String shardId;
    private final String host;
    private final String port;
    private final String dbname;
    private final String dc;

    public ConnInfo(final String shardId, final Map<?, ?> map)
        throws JsonUnexpectedTokenException
    {
        this.shardId = shardId;
        host = ValueUtils.asString(map.get("host"));
        port = ValueUtils.asString(map.get("port"));
        dbname = ValueUtils.asString(map.get("dbname"));
        dc = ValueUtils.asString(map.get("dataCenter"));
    }

    public String shardId() {
        return shardId;
    }

    public String dc() {
        return dc;
    }

    public String pgUrl() {
        return "jdbc:postgresql://" + host + ':' + port + '/' + dbname;
    }
}

