package ru.yandex.search.sharpei;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncDomConsumer;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class ConnInfoConsumer extends AbstractJsonAsyncDomConsumer<ConnInfo> {
    public ConnInfoConsumer(final HttpEntity entity) throws HttpException {
        super(entity);
    }

    @Override
    protected ConnInfo buildResult(
        final HttpContext context,
        final Object value)
        throws SharpeiException
    {
        try {
            ConnInfo connInfo = new ShardInfo(ValueUtils.asMap(value)).first();
            if (connInfo == null) {
                throw new SharpeiException(
                    "No usable databases found: " + value);
            }
            return connInfo;
        } catch (JsonUnexpectedTokenException e) {
            throw new SharpeiException("Failed to parse " + value, e);
        }
    }
}

