package ru.yandex.search.sharpei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class ShardInfo {
    private static final String FOR_SHARD = "For shard #";

    private final String id;
    private final ConnInfo first;
    private final ConnInfo master;
    private final List<ConnInfo> replicas;

    public ShardInfo(final Map<?, ?> shard)
        throws JsonUnexpectedTokenException, SharpeiException
    {
        id = ValueUtils.asString(shard.get("id"));
        List<?> hosts = ValueUtils.asList(shard.get("databases"));
        ConnInfo master = null;
        int size = hosts.size();
        replicas = new ArrayList<>(size);
        ConnInfo first = null;
        for (int i = 0; i < size; ++i) {
            Map<?, ?> host = ValueUtils.asMap(hosts.get(i));
            if ("dead".equals(host.get("status"))) {
                continue;
            }
            ConnInfo connInfo =
                new ConnInfo(id, ValueUtils.asMap(host.get("address")));
            String role = ValueUtils.asString(host.get("role"));
            switch (role) {
                case "master":
                    master = connInfo;
                    break;
                case "replica":
                    replicas.add(connInfo);
                    break;
                case "unknown":
                    continue;
                default:
                    throw new SharpeiException(
                        FOR_SHARD + id + " role '" + role
                        + "' is not recognized at host object #" + i
                        + ": " + hosts);
            }
            if (first == null) {
                first = connInfo;
            }
        }
        this.first = first;
        this.master = master;
    }

    public String id() {
        return id;
    }

    public ConnInfo first() {
        return first;
    }

    public ConnInfo master() {
        return master;
    }

    public List<ConnInfo> replicas() {
        return replicas;
    }
}

