package ru.yandex.search.sharpei;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncDomConsumer;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class ShardInfoConsumer
    extends AbstractJsonAsyncDomConsumer<ShardInfo>
{
    private final String shardId;

    public ShardInfoConsumer(final HttpEntity entity, final String shardId)
        throws HttpException
    {
        super(entity);
        this.shardId = shardId;
    }

    @Override
    protected ShardInfo buildResult(
        final HttpContext context,
        final Object value)
        throws SharpeiException
    {
        try {
            Object shardInfo = ValueUtils.asMap(value).get(shardId);
            if (shardInfo == null) {
                throw new SharpeiNotFoundException(
                    "Shard " + shardId + " wasn't found in " + value);
            }
            return new ShardInfo(ValueUtils.asMap(shardInfo));
        } catch (JsonUnexpectedTokenException e) {
            throw new SharpeiException(
                "Failed to parse shard " + shardId + " from " + value,
                e);
        }
    }
}

