package ru.yandex.search.sharpei;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public class ShardInfoConsumerFactory
    implements HttpAsyncResponseConsumerFactory<ShardInfo>
{
    private final String shardId;

    public ShardInfoConsumerFactory(final String shardId) {
        this.shardId = shardId;
    }

    @Override
    public ShardInfoConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new ShardInfoConsumer(response.getEntity(), shardId);
    }
}

