package ru.yandex.search.sharpei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class ShardsIdsConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<List<String>>
{
    public ShardsIdsConsumer(
        final HttpEntity entity)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    protected List<String> buildResult(
        final HttpContext context,
        final JsonObject value)
        throws Exception
    {
        List<String> shards = new ArrayList<>();
        try {
            for (Map.Entry<String, JsonObject> entry
                : value.asMap().entrySet())
            {
                JsonMap map = entry.getValue().asMap();
                shards.add(map.getString("id"));
            }
        } catch (JsonUnexpectedTokenException e) {
            throw new SharpeiException(
                "Failed to parse shards "
                    + JsonType.NORMAL.toString(value),
                e);
        }

        return shards;
    }
}

