#!/bin/bash
set -exo pipefail

source mail-config-base.sh
export TVM_API_HOST=https://tvm-api.yandex.net

case "$NANNY_SERVICE_ID" in
    mail_search_tupita)
        export TUPITA_CONFIG=tupita_prod.conf
        export TVM_CLIENT_ID=2000031
        export TIKAITE_HOST=tikaite-fast-srw.ape.yandex.net
        export DISK_ISOLATION=0
        export GENCFG_GROUPS="MAN_MAIL_TUPITA_2,MSK_MYT_MAIL_TUPITA_2,SAS_MAIL_TUPITA_2,VLA_MAIL_TUPITA_2"
        export TUPITA_LJINX_REPLICAS=2
        export LOGS_BASE_DIR="/db/bsconfig/webcache/$BSCONFIG_INAME/logs/"
        ;;
    *_qa)
        export TUPITA_CONFIG=tupita_qa.conf
        export TVM_CLIENT_ID=186
        export TIKAITE_HOST=tikaite-fast-srw.tst.ape.yandex.net
        export DISK_ISOLATION=1
        export LOGS_BASE_DIR="/logs"
        export GENCFG_GROUPS="TUPITA_QA"
        export TUPITA_LJINX_REPLICAS=1
        ;;
    mail_search_delivery_proxy_prod*)
        export TUPITA_CONFIG=mail_search_delivery.conf
        export TVM_CLIENT_ID=2000031
        export TIKAITE_HOST=tikaite-fast-srw.ape.yandex.net
        export DISK_ISOLATION=1
        export LOGS_BASE_DIR="/logs"
        export GENCFG_GROUPS="MAN_MAIL_TUPITA_2,MSK_MYT_MAIL_TUPITA_2,SAS_MAIL_TUPITA_2,VLA_MAIL_TUPITA_2"
        export TUPITA_LJINX_REPLICAS=1
        ;;

esac

export YT_ACCESS_LOG="$LOGS_BASE_DIR/tupita_access.json.log"
export PUSHCLIENT_DEFAULT_LOG_NAME=$YT_ACCESS_LOG
export PUSHCLIENT_DEFAULT_TOPIC="/mail-search/mail-search-stat-log"