#!/bin/bash

#export GC_ARGS="-XX:ActiveProcessorCount=6 \
#	-XX:+IgnoreUnrecognizedVMOptions \
#	-XcompilationThreads1 \
#	-Xgc:concurrentScavengeBackground=2 \
#	-Xgc:concurrentScavenge \
#	-XX:IdleTuningGcOnIdle \
#	-XX:IdleTuningMinIdleWaitTime=1 \
#	-Xgc:maxScavengeBeforeGlobal=100 \
#	-Xgcthreads5 \
#	-Xconcurrentbackground2 \
#	-Xgc:concurrentMark \
#	-Xaggressive \
#	-Xsoftrefthreshold100000000 \
#	-Xjit:scratchSpaceLimit=65536 \
#	-verbose:gc \
#	-Xverbosegclog:/dev/shm/gc.log,10,10000 \
#	-Xtune:virtualized"

XMX=$MEMORY_LIMIT
XMS=$((XMX / 4))

export GC_ARGS="
-XX:ActiveProcessorCount=$CPU_CORES
-XX:+IgnoreUnrecognizedVMOptions
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=/cores
-XcompilationThreads1
-Xmx$XMX
-Xms1G
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=2
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahUncommitDelay=30000
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:ShenandoahGarbageThreshold=10
-XX:+PrintCodeCache
-XX:ParallelGCThreads=$CPU_CORES
-XX:MaxHeapFreeRatio=20
-XX:MinHeapFreeRatio=10
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-Xlog:gc*:/dev/shm/gclogs/gc.log
"