#!/bin/bash
set -exo pipefail

source recommended_java_args.sh
source tupita_config.sh
source classpath.sh

#XMX=$(portoctl get . memory_limit_total)
#XMX=$((XMX*80/100))
#-Xmso128K \
#	-Xmcrs64M \

touch searchmap_mail.txt
if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi

if [ "$MEMORY_LIMIT" = "0" ]; then
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["memory_guarantee"]' | awk '{print int($1*0.8)}')
fi

if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1 + 0.2)}')
else
    #export CPU_CORES=$(cat dump.json | jq -r '.container.constraints.cpu_limit' | grep -Eo '[0-9\.]+' | awk '{print int($1 + 0.2)}')
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1 + 0.2)}')
fi

export TUPITA_LJINX_CONFIG="tupita_ljinx.conf"

APP_ARGS="-DLUCENE_CONFIG_DIR=$BSCONFIG_IDIR"

source tupita_gc_args.sh

exec $BSCONFIG_IDIR/jdk/bin/java \
    $DUMP_ARGS $GC_ARGS $NET_ARGS $APP_ARGS \
    -Djava.library.path=tupita \
    -cp $CLASSPATH \
    ru.yandex.multistarter.MultiStarter \
	  ru.yandex.search.mail.tupita.Tupita \
    $TUPITA_CONFIG ";" \
    ru.yandex.ljinx.Ljinx \
    $TUPITA_LJINX_CONFIG

