package ru.yandex.search.mail.tupita;

import java.io.IOException;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.dbfields.FilterSearchFields;
import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.dbfields.OracleFields;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonBoolean;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.search.document.mail.JsonFirstlineMailMetaHandler;
import ru.yandex.search.document.mail.MailMetaInfo;

public abstract class AbstractQueryCheckHandler
    implements HttpAsyncRequestHandler<JsonObject>
{
    public static final String SPAM = "spam";

    public static final String QUERIES = "queries";
    protected static final String MESSAGE = "message";
    protected static final String UID = "uid";
    protected static final String USERS = "users";
    protected static final String LABELS = "labels";
    protected static final String DISLPAY_NAME_SNAKE = "display_name";

    protected final Tupita tupita;

    protected AbstractQueryCheckHandler(final Tupita tupita) {
        this.tupita = tupita;
    }

    @Override
    public HttpAsyncRequestConsumer<JsonObject> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException, IOException
    {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Payload expected");
        }

        return new JsonAsyncTypesafeDomConsumer(
            ((HttpEntityEnclosingRequest) request).getEntity(),
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    protected void validateContact(final JsonMap concat) throws JsonException {
        JsonObject name =
            concat.getOrDefault(
                FilterSearchFields.ADDR_DISPLAY_NAME,
                JsonNull.INSTANCE);
        if (name == JsonNull.INSTANCE) {
            name = concat.get(DISLPAY_NAME_SNAKE);
            concat.put(FilterSearchFields.ADDR_DISPLAY_NAME, name);
        }
    }

    protected void validateContacts(
        final JsonMap message,
        final String field)
        throws JsonException
    {
        JsonList contacts = message.getListOrNull(field);
        if (contacts != null) {
            for (JsonObject o: contacts) {
                validateContact(o.asMap());
            }
        }
    }

    protected TupitaMailMetaInfo parseMessage(
        final ProxySession session,
        final JsonMap message,
        final long prefix)
        throws JsonException
    {
        // fill message with missing data, magic for tupita
        JsonString id =
            new JsonString(String.valueOf(System.currentTimeMillis()));
        message.put(MailMetaInfo.MID, new JsonLong(prefix));

        message.put("threadId", id);
        message.put("receiveDate", id);

        JsonMap subjectInfo = new JsonMap(BasicContainerFactory.INSTANCE);
        subjectInfo.put(
            OracleFields.SUBJECT,
            message.get(OracleFields.SUBJECT));
        message.put("subjectInfo", subjectInfo);

        message.put(OracleFields.FID, TupitaMailMetaInfo.DEFAULT_FID);
        message.put("folder", TupitaMailMetaInfo.DEFAULT_FOLDER);
        int attachments = message.getInt(MailMetaInfo.ATTACHMENTS_COUNT, 0);
        JsonMap labelsInfo =
            message.getMapOrNull(FilterSearchFields.LABELS_INFO);
        JsonList labels =
            message.getListOrNull(FilterSearchFields.LABELS);
        if (labels == null) {
            labels = new JsonList(BasicContainerFactory.INSTANCE);
        }

        if (labelsInfo == null) {
            labelsInfo = new JsonMap(BasicContainerFactory.INSTANCE);
        }

        if (labelsInfo.containsKey(FilterSearchFields.DOMAIN_LABEL)) {
            labels.add(new JsonString(FilterSearchFields.DOMAIN_LABEL));
        }

        if (attachments > 0) {
            labels.addAll(TupitaMailMetaInfo.ATTACH_LABELS);
            labelsInfo.put(
                TupitaMailMetaInfo.FAKE_ATTACHED_LBL,
                TupitaMailMetaInfo.ATTACH_LABEL_INFO);
            message.put(MailMetaInfo.HAS_ATTACHMENTS, JsonBoolean.TRUE);
        }

        message.put(FilterSearchFields.LABELS, labels);
        message.put(FilterSearchFields.LABELS_INFO, labelsInfo);

        // PS-3098
        validateContacts(message, MailMetaInfo.TO);
        validateContacts(message, MailMetaInfo.FROM);
        validateContacts(message, MailMetaInfo.CC);
        validateContacts(message, MailMetaInfo.BCC);
        validateContacts(message, MailMetaInfo.REPLY_TO);
        //
        TupitaMailMetaInfo meta = new TupitaMailMetaInfo(prefix);

        new JsonFirstlineMailMetaHandler(meta)
            .handle(message);

        meta.set(MailMetaInfo.UID, String.valueOf(prefix));
        if (message.getBoolean(SPAM, false)) {
            meta.set(MailIndexFields.FOLDER_TYPE, SPAM);
        }

        return meta;
    }
}
