package ru.yandex.search.mail.tupita;

import java.util.Collection;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.FilterFutureCallback;

public abstract class AbstractTupitaIndexCallback
    extends FilterFutureCallback<Collection<String>>
{
    protected final TupitaIndexationContext context;
    protected final long startTime;

    protected AbstractTupitaIndexCallback(
        final TupitaIndexationContext context,
        final FutureCallback<? super Collection<String>> callback)
    {
        super(callback);

        this.startTime = System.currentTimeMillis();
        this.context = context;
    }

    protected void logUncaughtException(final Exception e) {
        context.session().logger().info(
            "Meta " + String.valueOf(context.meta().toFastDocMap()));
        context.session().logger().log(
            Level.SEVERE,
            "Uncaught exception",
            e);
    }
}
