package ru.yandex.search.mail.tupita;

public abstract class AbstractTupitaQuery implements TupitaQuery {
    private final String id;
    private final int index;
    private final boolean stop;

    protected AbstractTupitaQuery(
        final String id,
        final int index)
    {
        this(id, index, false);
    }

    protected AbstractTupitaQuery(
        final String id,
        final int index,
        final boolean stop)
    {
        this.id = id;
        this.index = index;
        this.stop = stop;
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public int index() {
        return index;
    }

    @Override
    public boolean stop() {
        return stop;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractTupitaQuery)) {
            return false;
        }

        AbstractTupitaQuery that = (AbstractTupitaQuery) o;

        return id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public String toString() {
        return "TupitaQuery "
            + "id='" + id + '\''
            + ", index=" + index
            + ", stop=" + stop;
    }
}
