package ru.yandex.search.mail.tupita;

import org.apache.lucene.search.Query;

public class AsyncParseTupitaQuery extends AbstractTupitaQuery {
    private final String rawQuery;

    private volatile Query query = null;

    public AsyncParseTupitaQuery(
        final String id,
        final String query,
        final int index)
    {
        super(id, index);

        this.rawQuery = query;
    }

    // CSOFF: ParameterNumber
    public AsyncParseTupitaQuery(
        final String id,
        final String query,
        final int index,
        final boolean stop)
    {
        super(id, index, stop);

        this.rawQuery = query;
    }
    // CSON: ParameterNumber

    public String rawQuery() {
        return rawQuery;
    }

    public AsyncParseTupitaQuery query(final Query query) {
        this.query = query;
        return this;
    }

    @Override
    public Query luceneQuery() {
        return query;
    }

    @Override
    public String toString() {
        return super.toString() + ' '
            + "rawQuery='" + rawQuery + '\''
            + ", query=" + query;
    }
}
