package ru.yandex.search.mail.tupita;

import java.util.concurrent.atomic.AtomicLong;

public class BasicQueriesLimiter implements QueriesLimiter {
    private final AtomicLong counter = new AtomicLong(0L);
    private final long limit;

    public BasicQueriesLimiter(final long limit) {
        this.limit = limit;
    }

    @Override
    public boolean acquire(final long cnt) {
        if (counter.get() < limit) {
            counter.addAndGet(cnt);
            return true;
        }

        return false;
    }

    @Override
    public void release(final long cnt) {
        counter.addAndGet(-cnt);
    }

    @Override
    public long get() {
        return counter.get();
    }
}
