package ru.yandex.search.mail.tupita;

import java.util.concurrent.atomic.AtomicLong;

public class FakeQueriesLimiter implements QueriesLimiter {
    private final AtomicLong counter = new AtomicLong(0L);

    public FakeQueriesLimiter() {
    }

    @Override
    public boolean acquire(final long cnt) {
        counter.addAndGet(cnt);
        return true;
    }

    @Override
    public void release(final long cnt) {
        counter.addAndGet(-cnt);
    }

    @Override
    public long get() {
        return counter.get();
    }
}
