package ru.yandex.search.mail.tupita;

import java.util.AbstractMap;
import java.util.Map;

import org.apache.http.HeaderIterator;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncDomConsumer;

public class KeepHeadersJsonAsyncConsumer
    extends AbstractJsonAsyncDomConsumer<Map.Entry<Object, HeaderIterator>>
{
    private final HeaderIterator headerIterator;

    public KeepHeadersJsonAsyncConsumer(
        final HttpResponse response)
        throws HttpException
    {
        super(response.getEntity());

        this.headerIterator = response.headerIterator();
    }

    @Override
    protected Map.Entry<Object, HeaderIterator> buildResult(
        final HttpContext context,
        final Object value)
        throws Exception
    {
        return new AbstractMap.SimpleEntry<>(value, headerIterator);
    }
}
