package ru.yandex.search.mail.tupita;

import java.util.Map;

import org.apache.http.HeaderIterator;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class KeepHeadersJsonAsyncDomConsumerFactory
    implements HttpAsyncResponseConsumerFactory<
    Map.Entry<Object, HeaderIterator>>
{
    public static final KeepHeadersJsonAsyncDomConsumerFactory INSTANCE =
        new KeepHeadersJsonAsyncDomConsumerFactory();
    public static final StatusCheckAsyncResponseConsumerFactory<
        Map.Entry<Object, HeaderIterator>> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    protected KeepHeadersJsonAsyncDomConsumerFactory() {
    }

    @Override
    public KeepHeadersJsonAsyncConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new KeepHeadersJsonAsyncConsumer(response);
    }
}

