package ru.yandex.search.mail.tupita;

import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.http.concurrent.FutureCallback;

public class LimitReleasingCallback<T> implements FutureCallback<T> {
    private final Tupita tupita;
    private final FutureCallback<T> next;
    private final long queries;

    private final AtomicBoolean done = new AtomicBoolean(false);

    public LimitReleasingCallback(
        final Tupita tupita,
        final FutureCallback<T> next,
        final long queries)
    {
        this.tupita = tupita;
        this.next = next;
        this.queries = queries;
    }

    public void checkAndRelease() {
        if (done.compareAndSet(false, true)) {
            tupita.releaseLimit(queries);
        }
    }

    @Override
    public void completed(final T t) {
        checkAndRelease();

        next.completed(t);
    }

    @Override
    public void failed(final Exception e) {
        checkAndRelease();

        next.failed(e);
    }

    @Override
    public void cancelled() {
        checkAndRelease();

        next.cancelled();
    }
}
