package ru.yandex.search.mail.tupita;

import java.util.Collection;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

public class MultiIndexationCallback
    implements FutureCallback<Collection<String>>
{
    private final List<FutureCallback<? super Collection<String>>> cbs;

    public MultiIndexationCallback(
        final List<FutureCallback<? super Collection<String>>> cbs)
    {
        this.cbs = cbs;
    }

    @Override
    public void completed(final Collection<String> urls) {
        cbs.forEach((c) -> c.completed(urls));
    }

    @Override
    public void failed(final Exception e) {
        cbs.forEach((c) -> c.failed(e));
    }

    @Override
    public void cancelled() {
        cbs.forEach((c) -> c.cancelled());
    }
}
