package ru.yandex.search.mail.tupita;

import java.util.Collection;
import java.util.function.Function;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;

public class StringCollectionConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<Collection<String>>
{
    private final Function<Integer, Collection<String>> collectionFactory;

    public StringCollectionConsumer(
        final Function<Integer, Collection<String>> collectionFactory,
        final HttpEntity entity)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);

        this.collectionFactory = collectionFactory;
    }

    @Override
    protected Collection<String> buildResult(
        final HttpContext context,
        final JsonObject value)
        throws Exception
    {
        JsonList list = value.asList();
        Collection<String> result = collectionFactory.apply(list.size());

        for (JsonObject o: list) {
            result.add(o.asString());
        }

        return result;
    }
}
