package ru.yandex.search.mail.tupita;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Function;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public enum StringCollectionConsumerFactory implements
    HttpAsyncResponseConsumerFactory<Collection<String>>
{
    LIST(ArrayList::new),
    SET(HashSet::new),
    ORDERED_SET(LinkedHashSet::new);

    public static final StatusCheckAsyncResponseConsumerFactory<Collection
        <String>>
        DEFAULT_OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            LIST);

    private final Function<Integer, Collection<String>> collectionFactory;

    StringCollectionConsumerFactory(
        final Function<Integer, Collection<String>> collectionFactory)
    {
        this.collectionFactory = collectionFactory;
    }

    @Override
    public StringCollectionConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new StringCollectionConsumer(
            collectionFactory,
            response.getEntity());
    }
}
