package ru.yandex.search.mail.tupita;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.DollarJsonWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.KamajiIndexer;

public class TikaiteLessTupitaIndexer extends TikaiteTupitaIndexer {
    public TikaiteLessTupitaIndexer(final Tupita tupita) {
        super(tupita);
    }

    @Override
    public void index(
        final TupitaIndexationContext context,
        final FutureCallback<? super Collection<String>> callback)
    {
        List<String> urls =
            Collections.singletonList(context.url(MailMetaInfo.ZERO_HID));

        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();

        try (JsonWriter writer =
                 new DollarJsonWriter(
                     new OutputStreamWriter(out, tupita.lucene().charset())))
        {
            writer.startObject();
            KamajiIndexer.writeFastDocumentWithPrelude(writer, context);
            writer.endObject();
            writer.endArray();
            writer.endObject();
        } catch (IOException e) {
            callback.failed(e);
            return;
        }

        index(context, urls, out.toByteArray(), callback);
    }
}
