package ru.yandex.search.mail.tupita;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

import org.apache.http.HttpException;
import org.apache.http.message.BasicHttpRequest;

import ru.yandex.function.NullConsumer;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.MessageContext;
import ru.yandex.msearch.RequestContext;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.update.IndexationContext;
import ru.yandex.search.prefix.LongPrefix;

public class TupitaIndexationContext
    implements IndexationContext, RequestContext, MessageContext
{
    private final Tupita tupita;
    private final TupitaMailMetaInfo meta;
    private final ProxySession session;
    private final String stid;
    private final PrefixedLogger luceneLogger;
    private final boolean debug;
    private final QueryParseErrorPolicy queryParseErrorPolicy;

    private final long prefix;
    private final LongPrefix longPrefix;

    public TupitaIndexationContext(
        final Tupita tupita,
        final ProxySession session,
        final TupitaMailMetaInfo meta)
        throws HttpException
    {
        this.tupita = tupita;
        this.meta = meta;
        this.session = session;
        this.prefix = meta.prefix();
        String sessionId = (String) session.context().getAttribute(
            HttpServer.SESSION_ID);

        this.luceneLogger =
            tupita.config().loggers().preparedLoggers().get(
                new RequestInfo(
                    new BasicHttpRequest(
                        RequestHandlerMapper.GET,
                        "/lucene/full")))
                .addPrefix(sessionId);

        this.stid = meta.get(MailMetaInfo.STID);
        this.debug = session.params().getBoolean("debug", false);
        this.queryParseErrorPolicy = session.params().getEnum(
            QueryParseErrorPolicy.class,
            "parse-error",
            tupita.config().defaultParseErrorPolicy());
        this.longPrefix = new LongPrefix(prefix);
    }

    @Override
    public AsyncClient indexClient() {
        return null;
    }

    public Tupita tupita() {
        return tupita;
    }

    public ProxySession session() {
        return session;
    }

    @Override
    public MailMetaInfo meta() {
        return meta;
    }

    @Override
    public String url(final String hid) {
        return meta.url(hid);
    }

    @Override
    public Collection<String> preserveFields() {
        return Collections.emptyList();
    }

    @Override
    public Map<?, ?> updates() {
        return Collections.emptyMap();
    }

    @Override
    public long prefix() {
        return prefix;
    }

    public LongPrefix longPrefix() {
        return longPrefix;
    }

    public String stid() {
        return stid;
    }

    @Override
    public void checkAbort() throws IOException {
    }

    @Override
    public PrefixedLogger logger() {
        return luceneLogger;
    }

    @Override
    public Consumer<? super Integer> textLengthConsumer() {
        return NullConsumer.INSTANCE;
    }

    public boolean debugRequest() {
        return debug;
    }

    public QueryParseErrorPolicy queryParseErrorPolicy() {
        return queryParseErrorPolicy;
    }
}
