package ru.yandex.search.mail.tupita;

import java.util.Map;

import ru.yandex.dbfields.FilterSearchFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.search.document.mail.FirstlineMailMetaInfo;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.subscriptions.SubsBaseModule;

public class TupitaMailMetaInfo extends FirstlineMailMetaInfo {
    public static final JsonString DEFAULT_FID = new JsonString("1");
    public static final JsonList DEFAULT_LABELS =
        new JsonList(BasicContainerFactory.INSTANCE);
    public static final JsonList ATTACH_LABELS;
    public static final JsonMap ATTACH_LABEL_INFO;
    public static final String FAKE_ATTACHED_LBL = "FAKE_ATTACHED_LBL";
    public static final String SUBSCRIPTION_EMAIL = "subscription-email";

    public static final JsonMap DEFAULT_FOLDER;

    private static final String TUPITA_INDEX_TIME = "tupita_index_time";
    private static final int THOUSAND = 1000;

    private static final char SEP = '_';
    private final long prefix;

    static {
        final String inbox = "inbox";

        JsonMap folder = new JsonMap(BasicContainerFactory.INSTANCE);
        folder.put("isUser", new JsonString("false"));
        folder.put(FilterSearchFields.NAME, new JsonString(inbox));
        JsonMap type = new JsonMap(BasicContainerFactory.INSTANCE);
        type.put(
            FilterSearchFields.TITLE,
            new JsonString(FilterSearchFields.TYPE_SYSTEM));

        folder.put(FilterSearchFields.TYPE, type);

        JsonMap symbolicName = new JsonMap(BasicContainerFactory.INSTANCE);
        symbolicName.put(FilterSearchFields.TITLE, new JsonString(inbox));

        folder.put(FilterSearchFields.SYMBOLIC_NAME, symbolicName);

        DEFAULT_FOLDER = folder;

        JsonList attachLabels = new JsonList(BasicContainerFactory.INSTANCE);
        attachLabels.add(new JsonString(FAKE_ATTACHED_LBL));

        ATTACH_LABELS = attachLabels;

        JsonMap attachLabelInfo = new JsonMap(BasicContainerFactory.INSTANCE);
        JsonMap attachTypeMap = new JsonMap(BasicContainerFactory.INSTANCE);
        attachTypeMap.put(
            FilterSearchFields.TITLE,
            new JsonString(FilterSearchFields.TYPE_SYSTEM));
        attachLabelInfo.put(FilterSearchFields.TYPE, attachTypeMap);

        JsonMap attachNameMap = new JsonMap(BasicContainerFactory.INSTANCE);
        attachNameMap.put(
            FilterSearchFields.TITLE,
            new JsonString(FilterSearchFields.ATTACHED_LABEL_TITLE));
        attachLabelInfo.put(FilterSearchFields.SYMBOLIC_NAME, attachNameMap);
        ATTACH_LABEL_INFO = attachLabelInfo;
    }

    public TupitaMailMetaInfo(final long prefix) {
        this.prefix = prefix;

        this.set(
            TUPITA_INDEX_TIME,
            String.valueOf(System.currentTimeMillis() / THOUSAND));
    }

    public long prefix() {
        return prefix;
    }

    @Override
    public String url(final String hid) {
        return url(hid, this);
    }

    public static String url(
        final String hid,
        final TupitaMailMetaInfo meta)
    {
        StringBuilder sb = new StringBuilder();
        sb.append(meta.prefix);
        sb.append(SEP);
        sb.append(
            meta.get(MailMetaInfo.STID).replaceAll(":", "."));
        sb.append('/');
        sb.append(hid);

        return sb.toString();
    }

    @Override
    public Map<String, String> toFastDocMap() {
        Map<String, String> map = super.toFastDocMap();
        String hdrFrom = map.get(
            MailMetaInfo.HDR + MailMetaInfo.FROM + MailMetaInfo.NORMALIZED);
        if (hdrFrom != null) {
            map.put(SUBSCRIPTION_EMAIL, SubsBaseModule.normalizeEmail(hdrFrom));
        }

        return map;
    }
}
