package ru.yandex.search.mail.tupita;

import org.apache.http.HttpException;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.util.server.LoggingServerConnection;

public class TupitaProxySession extends BasicProxySession {
    private final TupitaTikaiteListener listener = new TupitaTikaiteListener();
    private final Tupita tupita;

    public TupitaProxySession(
        final Tupita proxy,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        super(proxy, exchange, context);

        this.tupita = proxy;

        context()
            .getConnection(LoggingServerConnection.class)
            .setUpstreamStats(listener);
    }

    public TupitaProxySession(
        final Tupita proxy,
        final HttpAsyncExchange exchange,
        final HttpCoreContext context)
        throws HttpException
    {
        super(proxy, exchange, context);

        tupita = proxy;

        context()
            .getConnection(LoggingServerConnection.class)
            .setUpstreamStats(listener);
    }

    @Override
    public TupitaTikaiteListener listener() {
        return listener;
    }

    public Tupita tupita() {
        return tupita;
    }
}
