package ru.yandex.search.mail.tupita;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.nio.client.BasicRequestsListener;

public class TupitaTikaiteListener
    extends BasicRequestsListener
{
    private static final long serialVersionUID = 0L;

    private String uid = null;
    private String stid = null;

    public TupitaTikaiteListener() {
    }

    public synchronized void set(final String uid, final String stid) {
        this.uid = uid;
        this.stid = stid;
    }

    @Override
    public <T> FutureCallback<? super T> createCallbackFor(
        final HttpRoute route,
        final HttpRequest request,
        final HttpContext context)
    {
        if (uid == null || stid == null) {
            return super.createCallbackFor(route, request, context);
        }

        String hostname = route.getTargetHost().getHostName();
        StringBuilder sb =
            new StringBuilder(
                hostname.length()
                    + uid.length()
                    + stid.length() + 2);
        sb.append(hostname);
        sb.append('.');
        sb.append(uid);
        sb.append('.');
        sb.append(stid);
        HttpRoute filledRoute = new HttpRoute(
            new HttpHost(sb.toString(), route.getTargetHost().getPort()),
            route.getLocalAddress(),
            route.getProxyHost(),
            route.isSecure(),
            route.getTunnelType(),
            route.getLayerType());

        return super.createCallbackFor(filledRoute, request, context);
    }
}
