package ru.yandex.search.mail.tupita;

import java.io.File;
import java.io.IOException;

import ru.yandex.http.util.server.DefaultHttpServerFactory;
import ru.yandex.jniwrapper.JniWrapperException;
import ru.yandex.msearch.Daemon;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.sanitizer2.PageHeaderException;
import ru.yandex.tikaite.config.TikaiteConfigBuilder;
import ru.yandex.tikaite.server.Server;

public final class TupitaWithTikaiteMeta {
    private static final String CONFIG = "-config";

    private TupitaWithTikaiteMeta() {
    }

    public static void main(final String[] args) {
        final String tupitaConfig = args[0];
        final String luceneConfig = args[1];
        final String tikaiteConfig = args[2];

        Thread lucene = new Thread("lucene-main") {
            @Override
            public void run() {
                try {
                    Daemon.main(CONFIG, luceneConfig);
                } catch (Exception e) {
                    System.err.println("lucene failed to start");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        };
        lucene.start();

        Thread tupita = new Thread("tupita-main") {
            @Override
            public void run() {
                try {
                    Tupita.main(
                        new DefaultHttpServerFactory<>(Tupita.class),
                        tupitaConfig);
                } catch (Exception e) {
                    System.err.println("Tupita failed to start");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        };

        tupita.start();

        Thread tikaite = new Thread("tikaite-main") {
            @Override
            public void run() {
                try {
                    Server server = new Server(
                        new TikaiteConfigBuilder(
                            new IniConfig(new File(tikaiteConfig))).build());
                    server.start();
                } catch (ConfigException
                    | IOException
                    | JniWrapperException
                    | PageHeaderException e)
                {
                    System.err.println("Tikaite failed to start");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        };

        tikaite.start();
    }
}
