package ru.yandex.search.mail.tupita.admin360;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.search.mail.tupita.Tupita;

public class ConditionsConverterHandler implements ProxyRequestHandler {
    //private final Tupita tupita;

    public ConditionsConverterHandler(final Tupita tupita) {
        //this.tupita = tupita;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException, IOException {
        PrintCallback callback = new PrintCallback(session);
        HttpRequest request = session.request();
        if (!(request instanceof HttpEntityEnclosingRequest)) {
             callback.failed(new BadRequestException("Payload expected"));
             return;
        }
        HttpEntityEnclosingRequest postRequest = (HttpEntityEnclosingRequest) request;
        HttpEntity entity = postRequest.getEntity();
        String json = CharsetUtils.toString(entity);
        try {
            JsonMap map = TypesafeValueContentHandler.parse(json).asMap();
            JsonList conditions = map.getList("conditions");
            RuleParser2 parser = new RuleParser2();
            List<String> queries = new ArrayList<>();
            RuleParser2.ParseContext parseContext = new RuleParser2.ParseContext();
            for (int i = 0; i < conditions.size(); i++) {
                try {
                    JsonMap condMap = conditions.get(i).asMap();

                    RuleParser2.Condition parsedCondition = parser.parse(condMap, parseContext);
                    queries.add(parsedCondition.toStringFast());
                } catch (Exception pe) {
                    callback.failed(new ConvertException(pe, conditions.get(i),  i));
                    return;
                }
            }
            callback.completed(new ConvertResult(queries, parseContext.requiredFields()));
        } catch (JsonException je) {
            session.logger().info("Request failed, invalid json " + json);
            callback.failed(je);
        }
    }

    private static class PrintCallback implements ErrorFormattingCallback<ConvertResult> {
        private final ProxySession session;
        private final JsonType jsonType;

        public PrintCallback(final ProxySession session) throws BadRequestException {
            this.session = session;
            this.jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        }

        @Override
        public ProxySession session() {
            return session;
        }

        @Override
        public void failed(final Exception e) {
            if (!(e instanceof ConvertException)) {
                ErrorFormattingCallback.super.failed(e);
                return;
            }

            DecodableByteArrayOutputStream out =
                new DecodableByteArrayOutputStream();
            try (OutputStreamWriter outWriter =
                     new OutputStreamWriter(
                         out,
                         session.acceptedCharset().newEncoder()
                             .onMalformedInput(CodingErrorAction.REPLACE)
                             .onUnmappableCharacter(CodingErrorAction.REPLACE));
                 JsonWriter writer = jsonType.create(outWriter))
            {
                writer.value((JsonValue) e);
            } catch (IOException ioe) {
                failed(ioe);
                return;
            }
            NByteArrayEntity entity =
                out.processWith(NByteArrayEntityFactory.INSTANCE);
            entity.setContentType(
                ContentType.APPLICATION_JSON.withCharset(
                        session.acceptedCharset())
                    .toString());
            session.response(HttpStatus.SC_BAD_REQUEST, entity);
        }

        @Override
        public void completed(final ConvertResult convertResult) {
            DecodableByteArrayOutputStream out =
                new DecodableByteArrayOutputStream();
            try (OutputStreamWriter outWriter =
                     new OutputStreamWriter(
                         out,
                         session.acceptedCharset().newEncoder()
                             .onMalformedInput(CodingErrorAction.REPLACE)
                             .onUnmappableCharacter(CodingErrorAction.REPLACE));
                 JsonWriter writer = jsonType.create(outWriter))
            {
                writer.value(convertResult);
            } catch (IOException ioe) {
                failed(ioe);
                return;
            }

            NByteArrayEntity entity =
                out.processWith(NByteArrayEntityFactory.INSTANCE);
            entity.setContentType(
                ContentType.APPLICATION_JSON.withCharset(
                        session.acceptedCharset())
                    .toString());
            session.response(HttpStatus.SC_OK, entity);
        }
    }

    private static class ConvertResult implements JsonValue {
        private List<String> conditions;
        private Collection<String> requiredFields;

        public ConvertResult(
            final List<String> conditions,
            final Collection<String> requiredFields)
        {
            this.conditions = conditions;
            this.requiredFields = requiredFields;
        }

        public List<String> conditions() {
            return conditions;
        }

        public Collection<String> requiredFields() {
            return requiredFields;
        }

        @Override
        public void writeValue(final JsonWriterBase writer)
            throws IOException
        {
            writer.startObject();
            writer.key("status");
            writer.value("ok");
            writer.key("conditions");
            writer.startArray();
            for (String condition: conditions) {
                writer.startObject();
                writer.key("query");
                writer.value(condition);
                writer.endObject();
            }
            writer.endArray();
            writer.key("required_fields");
            writer.value(requiredFields);
            writer.endObject();
        }
    }
}
