package ru.yandex.search.mail.tupita.admin360;

import java.io.IOException;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class ConvertException extends Exception implements JsonValue {
    private final int offset;
    private final JsonObject condition;

    public ConvertException(final Throwable cause, final JsonObject condition, final int offset) {
        super(cause);
        this.offset = offset;
        this.condition = condition;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("status");
        writer.value("error");
        writer.key("error");
        writer.startObject();
        writer.key("error_type");
        writer.value("parse_error");
        writer.key("conditions");
        writer.startArray();
        writer.startObject();
        writer.key("condition");
        writer.value(condition);
        writer.key("message");
        writer.value(getMessage());
        writer.key("orig_index");
        writer.value(offset);
        writer.endObject();
        writer.endArray();
        writer.endObject();
        writer.endObject();
    }
}
