package ru.yandex.search.mail.tupita.admin360;

import java.util.List;

import ru.yandex.search.request.util.SearchRequestText;

public class FieldCondition implements RuleParser2.Condition {
    private final List<String> luceneFields;
    private final FieldMatchOperator operator;
    private final List<String> values;

    public FieldCondition(
        final List<String> luceneFields,
        final FieldMatchOperator operator,
        final List<String> values)
    {
        this.luceneFields = luceneFields;
        this.operator = operator;
        this.values = values;
    }

    private void applyLuceneField(final String field, final StringBuilder sb) {
        sb.append(field);
        sb.append(':');
        switch (operator) {
            case EXISTS:
            case NOT_EXISTS:
                if (values.size() == 1) {
                    sb.append(SearchRequestText.fullEscape(values.get(0), true));
                    sb.append('*');
                } else {
                    sb.append('*');
                }

                break;
            case EQUAL_ONE:
            case NOT_EQUAL_ONE:
                sb.append("\"");
                sb.append(values.get(0));
                sb.append("\"");
                break;

            case EQUAL_ANY:
            case NOT_EQUAL_ANY:
                sb.append('(');
                for (String value: values) {
                    sb.append("\"");
                    sb.append(value);
                    sb.append("\"");
                    sb.append(" OR ");
                }
                sb.setLength(sb.length() - 4);
                sb.append(')');
                break;
            case NOT_EQUAL_ALL:
                sb.append('(');
                for (String value: values) {
                    sb.append("\"");
                    sb.append(value);
                    sb.append("\"");
                    sb.append(" AND ");
                }
                sb.setLength(sb.length() - 5);
                sb.append(')');
                break;
            case CONTAINS_ONE:
            case NOT_CONTAINS_ONE:
                sb.append("(*");
                sb.append(SearchRequestText.fullEscape(values.get(0), true));
                sb.append("*)");
                break;
            case CONTAINS_ALL:
            case NOT_CONTAINS_ALL:
                sb.append('(');
                for (String value: values) {
                    sb.append("*");
                    sb.append(SearchRequestText.fullEscape(value, true));
                    sb.append("*");
                    sb.append(" AND ");
                }
                sb.setLength(sb.length() - 5);
                sb.append(')');
                break;

            case CONTAINS_ANY:
            case NOT_CONTAINS_ANY:
                sb.append('(');
                for (String value: values) {
                    sb.append("*");
                    sb.append(SearchRequestText.fullEscape(value, true));
                    sb.append("*");
                    sb.append(" OR ");
                }
                sb.setLength(sb.length() - 4);
                sb.append(')');
                break;
        }
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {

        if (luceneFields.size() == 1) {
            if (operator.negation()) {
                sb.append("mid_p:* AND NOT ");
            }
            applyLuceneField(luceneFields.get(0), sb);
        } else {
            if (operator.negation()) {
                sb.append("mid_p:* AND NOT ");
            }
            sb.append('(');
            for (String lf: luceneFields) {
                applyLuceneField(lf, sb);
                sb.append(" OR ");
            }
            sb.setLength(sb.length() - 4);
            sb.append(')');
        }
    }
}
