package ru.yandex.search.mail.tupita.config;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.mail.search.logbroker.logger.config.ImmutableLogbrokerLoggerConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.mail.tupita.QueryParseErrorPolicy;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableTupitaConfig
    extends ImmutableUniversalSearchProxyConfig
    implements TupitaConfig
{
    private final ImmutableHttpHostConfig tikaiteConfig;
    private final ImmutableHttpHostConfig fatcheckerConfig;
    private final IniConfig luceneConfig;
    private final ImmutableTvm2ClientConfig tvm2ClientConfig;
    private final int fatRequestLengthThreshold;
    private final int charsInBatch;
    private final int coreQueryParsingThreads;
    private final int maxQueryParsingThreads;
    private final int batchParseQueueSize;
    private final QueryParseErrorPolicy defaultParseErrorPolicy;
    private final ImmutableLogbrokerLoggerConfig logbrokerLogger;
    private final boolean subscriptionsPumpkin;

    public ImmutableTupitaConfig(
        final TupitaConfig config)
        throws ConfigException
    {
        super(config);
        this.tikaiteConfig =
            new ImmutableHttpHostConfig(
                config.tikaiteConfig());
        this.fatcheckerConfig =
            new ImmutableHttpHostConfig(
                config.fatcheckerConfig());
        this.luceneConfig = config.luceneConfig();
        this.fatRequestLengthThreshold = config.fatRequestLengthThreshold();
        this.charsInBatch = config.charsInBatch();
        this.coreQueryParsingThreads = config.coreQueryParsingThreads();
        this.maxQueryParsingThreads = config.maxQueryParsingThreads();
        this.batchParseQueueSize = config.batchParseQueueSize();

        this.subscriptionsPumpkin = config.subscriptionsPumpkin();

        this.tvm2ClientConfig =
            new ImmutableTvm2ClientConfig(config.tvm2ClientConfig());

        if (luceneConfig == null) {
            throw new ConfigException("No lucene config set");
        }

        this.defaultParseErrorPolicy = config.defaultParseErrorPolicy();
        this.logbrokerLogger =
            new ImmutableLogbrokerLoggerConfig(config.logbrokerLogger());
    }

    @Override
    public ImmutableHttpHostConfig tikaiteConfig() {
        return tikaiteConfig;
    }

    @Override
    public IniConfig luceneConfig() {
        return luceneConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    @Override
    public int fatRequestLengthThreshold() {
        return fatRequestLengthThreshold;
    }

    @Override
    public int coreQueryParsingThreads() {
        return coreQueryParsingThreads;
    }

    @Override
    public int maxQueryParsingThreads() {
        return maxQueryParsingThreads;
    }

    @Override
    public int batchParseQueueSize() {
        return batchParseQueueSize;
    }

    @Override
    public int charsInBatch() {
        return charsInBatch;
    }

    @Override
    public ImmutableHttpHostConfig fatcheckerConfig() {
        return fatcheckerConfig;
    }

    @Override
    public QueryParseErrorPolicy defaultParseErrorPolicy() {
        return defaultParseErrorPolicy;
    }

    @Override
    public ImmutableLogbrokerLoggerConfig logbrokerLogger() {
        return logbrokerLogger;
    }

    @Override
    public boolean subscriptionsPumpkin() {
        return subscriptionsPumpkin;
    }
}
