package ru.yandex.search.mail.tupita.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class TupitaConfigBuilder
    extends AbstractTupitaConfigBuilder<TupitaConfigBuilder>
{
    public TupitaConfigBuilder() {
        this(TupitaConfigDefaults.INSTANCE);
    }

    public TupitaConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, TupitaConfigDefaults.INSTANCE);
    }

    public TupitaConfigBuilder(final TupitaConfig config) {
        super(config);
    }

    public TupitaConfigBuilder(
        final IniConfig config,
        final TupitaConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableTupitaConfig build() throws ConfigException {
        return new ImmutableTupitaConfig(this);
    }

    @Override
    public TupitaConfigBuilder self() {
        return this;
    }
}
