package ru.yandex.search.mail.tupita.config;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.mail.search.logbroker.logger.config.LogbrokerLoggerConfig;
import ru.yandex.mail.search.logbroker.logger.config.LogbrokerLoggerConfigDefaults;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.mail.tupita.QueryParseErrorPolicy;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;

public class TupitaConfigDefaults
    extends UniversalSearchProxyConfigDefaults
    implements TupitaConfig
{
    public static final TupitaConfigDefaults INSTANCE =
        new TupitaConfigDefaults();

    private static final int FAT_THRESHOLD_BYTES = 30000;
    private static final int CHARS_IN_BATCH = 5000;
    private static final int BATCH_QUEUE_PARSE_SIZE = 10000;

    protected TupitaConfigDefaults() {
    }

    @Override
    public HttpHostConfig tikaiteConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public IniConfig luceneConfig() {
        return null;
    }

    @Override
    public Tvm2ClientConfig tvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public int fatRequestLengthThreshold() {
        return FAT_THRESHOLD_BYTES;
    }

    @Override
    public int charsInBatch() {
        return CHARS_IN_BATCH;
    }

    @Override
    public int coreQueryParsingThreads() {
        return workers();
    }

    @Override
    public int maxQueryParsingThreads() {
        return workers();
    }

    @Override
    public int batchParseQueueSize() {
        return BATCH_QUEUE_PARSE_SIZE;
    }

    @Override
    public HttpHostConfig fatcheckerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public QueryParseErrorPolicy defaultParseErrorPolicy() {
        return QueryParseErrorPolicy.SKIP;
    }

    @Override
    public LogbrokerLoggerConfig logbrokerLogger() {
        return LogbrokerLoggerConfigDefaults.INSTANCE;
    }

    @Override
    public boolean subscriptionsPumpkin() {
        return false;
    }
}
