package ru.yandex.search.mail.tupita.fat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.lucene.search.Query;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.search.mail.tupita.AbstractTupitaIndexCallback;
import ru.yandex.search.mail.tupita.AsyncParseTupitaQuery;
import ru.yandex.search.mail.tupita.TupitaIndexationContext;
import ru.yandex.search.mail.tupita.TupitaQuery;
import ru.yandex.stater.RequestInfo;
import ru.yandex.util.timesource.TimeSource;

public class AsyncParseQueriesChecker
    extends AbstractTupitaIndexCallback
{
    private final AtomicLong searchTime = new AtomicLong(0);
    private final AtomicBoolean done = new AtomicBoolean(false);

    private final AtomicInteger batchesLeft;

    private List<TupitaQuery> queries = null;
    private List<TupitaQuery> results;
    private Collection<String> urls = null;

    public AsyncParseQueriesChecker(
        final TupitaIndexationContext context,
        final int batches,
        final FutureCallback<? super Collection<String>> callback)
    {
        super(context, callback);

        this.results = new ArrayList<>();
        this.batchesLeft = new AtomicInteger(batches);
    }

    public Runnable newParseTask(final List<AsyncParseTupitaQuery> queries) {
        return new AsyncParseTask(queries);
    }

    @Override
    public void completed(final Collection<String> urls) {
        if (done.get()) {
            return;
        }

        context.session().logger().info("Message indexed");
        List<TupitaQuery> results = null;
        List<TupitaQuery> queries = null;
        try {
            synchronized (this) {
                if (!done.get()) {
                    if (this.queries != null && batchesLeft.get() <= 0) {
                        queries = this.queries;
                        results = this.results;
                    }

                    this.urls = urls;
                }
            }

            if (queries != null) {
                results.addAll(check(queries));
            }
        } catch (IOException ioe) {
            queryParseFailed(ioe);
        } catch (NullPointerException e) {
            logUncaughtException(e);
            queryParseFailed(new BadRequestException(e));
        }

        if (results != null
            && done.compareAndSet(false, true))
        {
            callback.completed(postprocess(results));
        }
    }

    private List<TupitaQuery> check(
        final List<? extends TupitaQuery> queries)
        throws IOException
    {
        long searchStart = TimeSource.INSTANCE.currentTimeMillis();

        IdentityMatchedQueryConsumer result =
            new IdentityMatchedQueryConsumer();
        context.tupita().lucene().search(context, queries, result);

        long finishTime = TimeSource.INSTANCE.currentTimeMillis();
        searchTime.addAndGet(finishTime - searchStart);
        if (batchesLeft.get() == 0) {
            context.tupita().queryParseStater().accept(
                new RequestInfo(
                    TimeSource.INSTANCE.currentTimeMillis(),
                    HttpStatus.SC_OK,
                    finishTime - searchTime.get(),
                    finishTime - searchTime.get(),
                    0L,
                    result.size()));
        }

        return result;
    }

    public void queryParsed(final List<? extends TupitaQuery> queries) {
        if (done.get()) {
            return;
        }

        if (batchesLeft.get() == 1) {
            context.tupita().queryParseStater().accept(
                new RequestInfo(
                    TimeSource.INSTANCE.currentTimeMillis(),
                    HttpStatus.SC_OK,
                    startTime,
                    startTime,
                    0L,
                    queries.size()));
        }

        context.session().logger().info("Batch received, checking");

        Collection<String> urls = null;
        List<TupitaQuery> results = null;
        try {
            synchronized (this) {
                if (done.get()) {
                    return;
                }

                if (this.urls == null) {
                    if (this.queries == null) {
                        this.queries = new ArrayList<>(
                            queries.size() * batchesLeft.get());
                    }

                    this.queries.addAll(queries);

                    batchesLeft.decrementAndGet();
                } else {
                    urls = this.urls;
                }
            }

            if (urls != null) {
                results = check(queries);
                List<TupitaQuery> savedQueries = null;
                synchronized (this) {
                    this.results.addAll(results);
                    if (batchesLeft.decrementAndGet() == 0) {
                        results = this.results;
                        savedQueries = this.queries;
                    } else {
                        results = null;
                    }
                }

                // ok this is last batch check all that left
                if (results != null && savedQueries != null) {
                    results.addAll(check(savedQueries));
                }
            }
        } catch (IOException ioe) {
            queryParseFailed(ioe);
        } catch (NullPointerException e) {
            context.session().logger().info("Queries " + queries);
            logUncaughtException(e);
            queryParseFailed(new BadRequestException(e));
        }

        if (results != null
            && done.compareAndSet(false, true))
        {
            callback.completed(postprocess(results));
        }

        context.session().logger().info(
            "Batch consumed, left " + batchesLeft.get());
    }

    public void queryParseFailed(final Exception e) {
        if (!done.compareAndSet(false, true)) {
            return;
        }

        callback.failed(e);
    }

    protected Collection<String> postprocess(
        final List<TupitaQuery> queries)
    {
        Collections.sort(queries);
        Set<String> result = new LinkedHashSet<>(queries.size());
        for (TupitaQuery query: queries) {
            result.add(query.id());

            if (query.stop()) {
                break;
            }
        }

        return result;
    }

    private final class AsyncParseTask implements Runnable {
        private final List<AsyncParseTupitaQuery> queries;

        private AsyncParseTask(
            final List<AsyncParseTupitaQuery> queries)
        {
            this.queries = queries;
        }

        @Override
        public void run() {
            try {
                for (AsyncParseTupitaQuery query : queries) {
                    Query luceneQuery = context.tupita().parseQueryWithPolicy(
                        context,
                        query.id(),
                        query.rawQuery());
                    query.query(luceneQuery);
                }

                queryParsed(queries);
            } catch (Exception e) {
                queryParseFailed(e);
            }
        }
    }
}
