package ru.yandex.search.mail.tupita.fat;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.Collection;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class FatQueryCheckCallback
    extends AbstractProxySessionCallback<Collection<String>>
{
    private final JsonType jsonType;
    private final Charset acceptedCharset;

    public FatQueryCheckCallback(
        final ProxySession session)
        throws HttpException
    {
        super(session);

        jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        acceptedCharset = CharsetUtils.acceptedCharset(session.request());
    }

    @Override
    public void completed(final Collection<String> matched) {
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();

        try (OutputStreamWriter outWriter =
                 new OutputStreamWriter(
                     out,
                     acceptedCharset.newEncoder()
                         .onMalformedInput(CodingErrorAction.REPLACE)
                         .onUnmappableCharacter(CodingErrorAction.REPLACE));
             JsonWriter writer = jsonType.create(outWriter))
        {
            writer.value(matched);
        } catch (IOException e) {
            failed(e);
            return;
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(acceptedCharset)
                .toString());
        session.response(HttpStatus.SC_OK, entity);
        session.logger().info("Request finished");
    }
}
