package ru.yandex.search.mail.tupita.light;

import java.util.Collection;
import java.util.List;
import java.util.Locale;

import org.apache.http.HttpStatus;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;
import ru.yandex.search.mail.tupita.BasicTupitaQuery;
import ru.yandex.search.mail.tupita.TikaiteLessTupitaIndexer;
import ru.yandex.search.mail.tupita.TikaiteTupitaIndexer;
import ru.yandex.search.mail.tupita.Tupita;
import ru.yandex.search.mail.tupita.TupitaIndexationContext;
import ru.yandex.search.mail.tupita.TupitaIndexer;
import ru.yandex.search.mail.tupita.TupitaQuery;
import ru.yandex.stater.RequestInfo;
import ru.yandex.util.timesource.TimeSource;

public abstract class AbstractSequentialParserHandler {
    private static final long ONE_SECOND = 1000;

    protected final TupitaIndexer noTikaiteIndexer;
    protected final TupitaIndexer tikaiteIndexer;
    protected final Tupita tupita;

    protected AbstractSequentialParserHandler(final Tupita tupita) {
        this.tikaiteIndexer = new TikaiteTupitaIndexer(tupita);
        this.noTikaiteIndexer = new TikaiteLessTupitaIndexer(tupita);
        this.tupita = tupita;
    }

    protected List<? extends TupitaQuery> prepare(
        final TupitaIndexationContext context,
        final JsonObject queriesObj)
        throws Exception
    {
        long startQueriesParse = TimeSource.INSTANCE.currentTimeMillis();

        RequestInfo parseStat;
        List<BasicTupitaQuery> queries;
        try {
            queries = parseQueries(context, queriesObj);
            parseStat = new RequestInfo(
                TimeSource.INSTANCE.currentTimeMillis(),
                HttpStatus.SC_OK,
                startQueriesParse,
                startQueriesParse,
                0L,
                queries.size());
            // we can not check if query is ok, only by call toString()
            if (parseStat.requestTime() > ONE_SECOND) {
                context.session().logger().info(
                    "Heavy sequential parse "
                        + JsonType.NORMAL.toString(queriesObj));
            } else {
                for (TupitaQuery query : queries) {
                    query.luceneQuery().toString();
                }
            }
        } catch (NullPointerException npe) {
            throw new BadRequestException(
                "Bad constructed queries "
                    + JsonType.NORMAL.toString(queriesObj));
        }

        context.tupita().queryParseStater().accept(parseStat);

        if (queries.isEmpty()) {
            context.session().logger().info("No queries, skipping");
        } else {
            context.session().logger().info(
                "Queries count is " + queries.size());
        }

        return queries;
    }

    public boolean needTikaite(
        final Collection<? extends TupitaQuery> queries)
    {
        // logic for do we need tikaite
        // for first logic is stupid like stupidity itself

        return queries.stream().anyMatch(
            q -> {
                String lower =
                    q.luceneQuery().toString().toLowerCase(Locale.ROOT);
                return lower.contains("body")
                    || lower.contains("headers")
                    || lower.contains("attachname");
            });
    }

    protected TupitaIndexer determineIndexer(
        final Collection<? extends TupitaQuery> queries)
    {
        if (!needTikaite(queries)) {
            return noTikaiteIndexer;
        }

        return tikaiteIndexer;
    }

    protected abstract List<BasicTupitaQuery> parseQueries(
        final TupitaIndexationContext context,
        final JsonObject queries)
        throws Exception;
}
