package ru.yandex.search.mail.tupita.light;

import java.util.ArrayList;
import java.util.function.Consumer;

import ru.yandex.search.mail.tupita.TupitaQuery;

public class MatchedQueriesIdConsumer
    extends ArrayList<String>
    implements Consumer<TupitaQuery>
{
    private static final long serialVersionUID = 1L;

    private volatile boolean stopped = false;

    public MatchedQueriesIdConsumer() {
    }

    @Override
    public void accept(final TupitaQuery query) {
        if (!stopped) {
            this.add(query.id());
            if (query.stop()) {
                stopped = true;
            }
        }
    }
}
