package ru.yandex.search.mail.tupita.light;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.lucene.search.Query;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.search.mail.tupita.BasicTupitaQuery;
import ru.yandex.search.mail.tupita.Tupita;
import ru.yandex.search.mail.tupita.TupitaIndexationContext;
import ru.yandex.search.mail.tupita.TupitaQuery;

public class NewFormatSequentialParserHandler
    extends AbstractSequentialParserHandler
{
    private static final long ONE_SECOND = 1000;

    public NewFormatSequentialParserHandler(final Tupita tupita) {
        super(tupita);
    }

    public List<? extends TupitaQuery> handle(
        final TupitaIndexationContext context,
        final JsonList queriesList)
        throws Exception
    {
        return prepare(context, queriesList);
    }

    @Override
    protected List<BasicTupitaQuery> parseQueries(
        final TupitaIndexationContext context,
        final JsonObject queriesObj)
        throws Exception
    {
        JsonList queries = queriesObj.asList();
        List<BasicTupitaQuery> result = new ArrayList<>(queries.size());

        int index = 0;

        long startPack = System.currentTimeMillis();
        long[] times = new long[queries.size()];

        for (int i = 0; i < queries.size(); i++) {
            JsonMap queryMap = queries.get(i).asMap();
            String id = queryMap.getString("id");
            String queryStr = queryMap.getString("query");
            boolean stop = queryMap.getBoolean("stop", false);
            if (queryStr == null || queryStr.isEmpty()) {
                continue;
            }

            long start = System.currentTimeMillis();
            Query query = tupita.parseQueryWithPolicy(context, id, queryStr);
            times[i] = System.currentTimeMillis() - start;

            if (query != null) {
                result.add(new BasicTupitaQuery(id, query, index++, stop));
            }

            tupita.sequentialParsedQueries().accept(1);
        }

        if (System.currentTimeMillis() - startPack > ONE_SECOND) {
            context.session().logger().warning(
                "Parse stat " + Arrays.toString(times));
        }

        return result;
    }
}
