package ru.yandex.search.mail.tupita.light;

import java.io.IOException;
import java.util.Collection;

import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.search.mail.tupita.AbstractTupitaIndexCallback;
import ru.yandex.search.mail.tupita.TupitaIndexationContext;
import ru.yandex.search.mail.tupita.TupitaQuery;
import ru.yandex.stater.RequestInfo;
import ru.yandex.util.timesource.TimeSource;

public class UserQueryChecker
    extends AbstractTupitaIndexCallback
{
    private final Collection<? extends TupitaQuery> queries;

    public UserQueryChecker(
        final TupitaIndexationContext context,
        final FutureCallback<? super Collection<String>> callback,
        final Collection<? extends TupitaQuery> queries)
    {
        super(context, callback);

        this.queries = queries;
    }

    @Override
    public void completed(final Collection<String> result) {
        long searchStart = TimeSource.INSTANCE.currentTimeMillis();
        try {
            MatchedQueriesIdConsumer matched = new MatchedQueriesIdConsumer();
            context.tupita().lucene().search(context, queries, matched);

            callback.completed(matched);

            context.tupita().searchStater().accept(
                new RequestInfo(
                    TimeSource.INSTANCE.currentTimeMillis(),
                    HttpStatus.SC_OK,
                    searchStart,
                    searchStart,
                    0L,
                    matched.size()));
        } catch (IOException ioe) {
            callback.failed(ioe);
        } catch (NullPointerException e) {
            context.session().logger().info("Queries " + queries);
            logUncaughtException(e);
            callback.failed(new BadRequestException(e));
        }
    }
}
